"use strict";

$(function () {

	// Overlay Menu Toggle

	$("[data-toggle=menu]").on("click", function () {
		if (!$("body").hasClass("show-menu")) {
			$("#meco-overlay-menu").css("display", "block");
			setTimeout(function () {
				$("body").addClass("show-menu");
			}, 50);

			if (!$("#meco-overlay-menu #categories").length) {
				$("#meco-overlay-menu").append($('#categories'));
			}

			if ($("#meco-overlay-menu #categories .navbar-categories-left").length > 1) {
				$("#meco-overlay-menu #categories .navbar-categories-left:last").remove();
			}
		} else {
			$("body").removeClass("show-menu");
			setTimeout(function () {
				$("#meco-overlay-menu").css("display", "none");
			}, 500);

			if (!$("#header #categories").length) {
				$("#header").append($('#categories'));
			}
		}
	});

	function open_cart(e) {
		e.preventDefault();
		if (!$("body").hasClass("show-cart") && $("#cart-container:visible").length < 1) {
			window.scrollTo(0, 0);
			$("#offcanvas-cart-overlay").css("display", "block");
			setTimeout(function () {
				$("body").addClass("show-cart");
			}, 50);
		} else {
			$("body").removeClass("show-cart");
			$("a[data-toggle='cart']:visible").first().focus();
			setTimeout(function () {
				$("#offcanvas-cart-overlay").css("display", "none");
			}, 500);
		}

		if (e.data.auto_close) {
			setTimeout(close_cart, 3000);
		}
	}

	function close_cart() {
		$("body").removeClass("show-cart");
		$("a[data-toggle='cart']:visible").first().focus();
		setTimeout(function () {
			$("#offcanvas-cart-overlay").css("display", "none");
		}, 500);
	}

	// Offcanvas Cart Toggle

	$("[data-toggle=cart]").on("click", { auto_close: false }, open_cart);
	$("#offcanvas-cart-overlay").on("click", close_cart);
	$(document).on("keyup", function (e) {
		e.preventDefault();
		e.stopPropagation();

		if ((e.keyCode === 9 || e.keyCode === 27) && $(e.target).closest("#offcanvas-cart-content").length === 0) {
			if ($("body").hasClass("show-cart") && $("#cart-container:visible").length === 0) {
				close_cart();
			}
		}
	});

	$('body').on("CART_DROPDOWN_OPEN", { auto_close: true }, open_cart);

	// Shopping Cart Product Count

	setTimeout(function () {
		$("body").trigger("CART_DROPDOWN_UPDATE");
	}, 1500);

	// Add special class to body element, if the visitor is using IE11
	if (!!navigator.userAgent.match(/Trident.*rv\:11\./)) {
		$("body").addClass("ie11");
	}

	// Disable next and previous arrows if current item is the last slide
	$('[data-wrap="false"]').each(function (index, carousel) {
		$(carousel).on('slid.bs.carousel', function () {
			var leftCarouselArrow = $(carousel).find('.left.carousel-control');
			var rightCarouselArrow = $(carousel).find('.right.carousel-control');

			var fistCarouselSlide = $(carousel).find('.item:first-child');
			if (fistCarouselSlide.hasClass('active')) {
				$(leftCarouselArrow).addClass('disabled');
			} else {
				$(leftCarouselArrow).removeClass('disabled');
			}

			var lastCarouselSlide = $(carousel).find('.item:last-child');
			if (lastCarouselSlide.hasClass('active')) {
				$(rightCarouselArrow).addClass('disabled');
			} else {
				$(rightCarouselArrow).removeClass('disabled');
			}
		});
	});

	// // Category Pages Left Sidebar Behavior

	// if ($("body.page-index-type-cat").length) {

	//     var $left = $("#left"),
	//        $listing = $(".category-product-listing"),
	//        $categories = $(".box-categories", $left),
	//        $filter = $(".box-filter", $left),
	//        leftIsInvisible = $left.css("display") == "none";

	//     if (leftIsInvisible && $categories.length) {

	//        var sidebarNeeded = false;

	//        // check if category menu has sub categories

	//        var $listItems = $("li", $categories),
	//            $activeListItem = $("li.active", $categories);

	//        if ($listItems.length && !$activeListItem.length) {
	//            sidebarNeeded = true;
	//        }

	//        // check if filters available


	//        // wrap product_listing
	//        $sidebar = $("<div class='category-sidebar col-md-3'></div>");
	//        $listing
	//            .addClass("row")
	//            .wrapInner("<div class='col-md-9'></div>")
	//            .prepend($sidebar);
	//        $categories.appendTo($sidebar);
	//        $filter.appendTo($sidebar);
	//     }
	// }
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
